﻿using Percent___Qualification_work.Classes;
using Percent___Qualification_work.Forms;
using System;
using System.Collections.Generic;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;

namespace Percent___Qualification_work.userControls
{
    public partial class gList : UserControl
    {
        private List<DataRow> gamesList = new List<DataRow>();
        private int currentPage = 1;
        private const int gamesPerPage = 10;

        public gList()
        {
            InitializeComponent();
        }

        public void LoadGames()
        {
            DataTable gamesTable = DatabaseConnection.Instance.GetUserGames(Authentication.ActiveUserID);
            gamesList = gamesTable.AsEnumerable().ToList();
            DisplayGames();
        }

        private void DisplayGames()
        {
            // Clear the existing controls
            flowLayoutPanel1.Controls.Clear();

            int startIndex = (currentPage - 1) * gamesPerPage;
            int endIndex = Math.Min(startIndex + gamesPerPage, gamesList.Count);

            // Add a card for each game in the current page
            for (int i = startIndex; i < endIndex; i++)
            {
                DataRow game = gamesList[i];
                Panel gameCard = CreateGameCard(game);
                flowLayoutPanel1.Controls.Add(gameCard);
            }
            UpdatePaginator();
        }

        private Panel CreateGameCard(DataRow game)
        {
            Panel card = new Panel
            {
                BorderStyle = BorderStyle.FixedSingle,
                Size = new Size(120, 158),
                Margin = new Padding(5),
                Cursor = Cursors.Hand // Change cursor to indicate clickability
            };

            PictureBox pictureBox = new PictureBox
            {
                SizeMode = PictureBoxSizeMode.StretchImage,
                Size = new Size(120, 120),
                Location = new Point(0, 0)
            };

            if (game["CoverImage"] is byte[] imageData)
            {
                pictureBox.Image = ConvertBytesToImage(imageData);
            }

            Label nameLabel = new Label
            {
                Text = game["GameName"].ToString(),
                Font = new Font("Arial", 8, FontStyle.Bold),
                AutoSize = false,
                TextAlign = ContentAlignment.MiddleCenter,
                Size = new Size(120, 30),
                Location = new Point(0, 125)
            };

            card.Controls.Add(pictureBox);
            card.Controls.Add(nameLabel);

            // Attach click event
            card.MouseClick += (s, e) => ShowGameDialog(game);
            pictureBox.MouseClick += (s, e) => ShowGameDialog(game);
            nameLabel.MouseClick += (s, e) => ShowGameDialog(game);
            return card;
        }

        private void UpdatePaginator()
        {
            prevButton.Enabled = currentPage > 1;
            nextButton.Enabled = currentPage * gamesPerPage < gamesList.Count;
            pageLabel.Text = $"Page {currentPage} of {Math.Ceiling((double)gamesList.Count / gamesPerPage)}";
        }

        private void prevButton_Click(object sender, EventArgs e)
        {
            if (currentPage > 1)
            {
                currentPage--;
                DisplayGames();
            }
        }

        private void nextButton_Click(object sender, EventArgs e)
        {
            if (currentPage * gamesPerPage < gamesList.Count)
            {
                currentPage++;
                DisplayGames();
            }
        }

        private Image ConvertBytesToImage(byte[] imageData)
        {
            using (var ms = new System.IO.MemoryStream(imageData))
            {
                return Image.FromStream(ms);
            }
        }

        private void ShowGameDialog(DataRow game)
        {
            using (GameDetailsDialog dialog = new GameDetailsDialog(game))
            {
                dialog.RefreshGames += LoadGames;
                dialog.ShowDialog();
            }
        }
    }
}
